/*
 * Decompiled with CFR 0.152.
 */
package silinit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import silinit.SilDice;

public class SilChar {
    protected SilDice dice = new SilDice();
    protected Random rand = new Random();
    protected boolean isAutoInit = true;
    protected String charName = "NPC Joe";
    protected String playName = "GM";
    protected int[] priAttrib = new int[10];
    protected final String[] priAttribDesc = new String[]{"ATT_AGILITY", "ATT_APPEARANCE", "ATT_BUILD", "ATT_CREATIVITY", "ATT_FITNESS", "ATT_INFLUENCE", "ATT_KNOWLEDGE", "ATT_PERCEPTION", "ATT_PSYCHE", "ATT_WILLPOWER"};
    protected int[] secAttrib = new int[5];
    protected final String[] secAttribDesc = new String[]{"STR", "HEA", "STA", "UD", "AD"};
    protected int skillCombatSense = 0;
    protected int skillMelee = 0;
    protected int skillHandToHand = 0;
    protected int curInitiative = 0;
    protected int curActions = 0;
    protected int prevActions = 0;
    protected int fleshWound = 0;
    protected int curFleshWound = 0;
    protected int deepWound = 0;
    protected int curDeepWound = 0;
    protected int instantDeath = 0;
    protected int woundModifier = 0;
    protected int systemShock = 0;
    protected int roundsTillDead = 0;
    protected boolean isShock = false;
    protected boolean isDead = false;

    public SilChar() {
    }

    public SilChar(File file) {
        this.playName = "Edit Me";
        String output = "";
        String data = "";
        try {
            FileReader zok = new FileReader(file);
            BufferedReader input = new BufferedReader(zok);
            while (input.ready()) {
                data = input.readLine();
                StringTokenizer dataT = new StringTokenizer(data, "<>");
                while (dataT.hasMoreTokens()) {
                    output = dataT.nextToken();
                    if (output.matches("NAME")) {
                        this.charName = dataT.nextToken();
                    }
                    int c = 0;
                    while (c < this.priAttribDesc.length) {
                        if (output.matches(this.priAttribDesc[c])) {
                            this.priAttrib[c] = Integer.parseInt(dataT.nextToken());
                        }
                        ++c;
                    }
                    if (output.matches("SKILL_HAND-TO-HAND")) {
                        this.skillHandToHand = Integer.parseInt(dataT.nextToken());
                    }
                    if (output.matches("SKILL_MELEE")) {
                        this.skillMelee = Integer.parseInt(dataT.nextToken());
                    }
                    if (!output.matches("SKILL_COMBAT SENSE")) continue;
                    this.skillCombatSense = Integer.parseInt(dataT.nextToken());
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.secAttrib[0] = (this.priAttrib[2] + this.priAttrib[4]) / 2;
        this.secAttrib[1] = (this.priAttrib[4] + this.priAttrib[8] + this.priAttrib[9]) / 3;
        this.secAttrib[2] = 25 + 5 * (this.priAttrib[2] + this.secAttrib[1]);
        if (this.secAttrib[2] < 10) {
            this.secAttrib[2] = 10;
        }
        this.secAttrib[3] = 3 + this.skillHandToHand + this.secAttrib[0] + this.priAttrib[2];
        if (this.secAttrib[3] < 1) {
            this.secAttrib[3] = 1;
        }
        this.secAttrib[4] = 3 + this.skillMelee + this.secAttrib[0] + this.priAttrib[2];
        if (this.secAttrib[4] < 1) {
            this.secAttrib[4] = 1;
        }
        this.systemShock = 5 + this.secAttrib[1];
        if (this.systemShock < 1) {
            this.systemShock = 1;
        }
        this.curFleshWound = this.fleshWound = this.secAttrib[2] / 2;
        this.curDeepWound = this.deepWound = this.secAttrib[2];
        this.instantDeath = this.secAttrib[2] * 2;
        this.isAutoInit = false;
    }

    public SilChar(int type, int tracker) {
        if (type == 1) {
            this.charName = String.valueOf(tracker) + " Random NPC";
            this.skillCombatSense = this.rand.nextInt(5);
            int i = 0;
            while (i < 10) {
                this.priAttrib[i] = this.rand.nextInt(10) - 4;
                ++i;
            }
        }
        if (type == 2) {
            this.charName = String.valueOf(tracker) + " Gear Pilot";
            this.skillCombatSense = 1;
            this.priAttrib[0] = 1;
            this.priAttrib[7] = 1;
        }
        if (type == 3) {
            this.charName = String.valueOf(tracker) + " Caravan Trader";
            this.skillCombatSense = 1;
            this.priAttrib[0] = 1;
            this.priAttrib[7] = 1;
        }
        if (type == 4) {
            this.charName = String.valueOf(tracker) + " Badlands Marshal";
            this.skillCombatSense = 1;
            this.priAttrib[4] = 1;
            this.priAttrib[5] = 1;
            this.priAttrib[7] = 1;
        }
        this.secAttrib[0] = (this.priAttrib[2] + this.priAttrib[4]) / 2;
        this.secAttrib[1] = (this.priAttrib[4] + this.priAttrib[8] + this.priAttrib[9]) / 3;
        this.secAttrib[2] = 25 + 5 * (this.priAttrib[2] + this.secAttrib[1]);
        if (this.secAttrib[2] < 10) {
            this.secAttrib[2] = 10;
        }
        this.secAttrib[3] = 3 + this.skillHandToHand + this.secAttrib[0] + this.priAttrib[2];
        if (this.secAttrib[3] < 1) {
            this.secAttrib[3] = 1;
        }
        this.secAttrib[4] = 3 + this.skillMelee + this.secAttrib[0] + this.priAttrib[2];
        if (this.secAttrib[4] < 1) {
            this.secAttrib[4] = 1;
        }
        this.systemShock = 5 + this.secAttrib[1];
        if (this.systemShock < 1) {
            this.systemShock = 1;
        }
        this.curFleshWound = this.fleshWound = this.secAttrib[2] / 2;
        this.curDeepWound = this.deepWound = this.secAttrib[2];
        this.instantDeath = this.secAttrib[2] * 2;
    }

    public String getCharName() {
        return this.charName;
    }

    public String getPlayName() {
        return this.playName;
    }

    public boolean getAutoInit() {
        return this.isAutoInit;
    }

    public String getCombatSense() {
        return String.valueOf(this.skillCombatSense) + "/" + this.priAttrib[7];
    }

    public int getCurInitiative() {
        return this.curInitiative;
    }

    public int getCurActions() {
        return this.curActions;
    }

    public int getPrevActions() {
        return this.prevActions;
    }

    public String getWound() {
        if (this.isDead) {
            return "Dead";
        }
        if (this.curFleshWound == this.fleshWound && this.curDeepWound == this.deepWound) {
            return String.valueOf(this.fleshWound) + "/" + this.deepWound + "/" + this.instantDeath + " [" + this.woundModifier + "]";
        }
        if (this.isShock) {
            return "(" + this.curFleshWound + ")" + this.fleshWound + "/(" + this.curDeepWound + ")" + this.deepWound + "/" + this.instantDeath + " S: " + this.roundsTillDead;
        }
        return "(" + this.curFleshWound + ")" + this.fleshWound + "/(" + this.curDeepWound + ")" + this.deepWound + "/" + this.instantDeath + " [" + this.woundModifier + "]";
    }

    public int getWoundModifier() {
        return this.woundModifier;
    }

    public boolean getIsDead() {
        return this.isDead;
    }

    public void setCharName(String name) {
        this.charName = name;
    }

    public void setPlayName(String name) {
        this.playName = name;
    }

    public void setAutoInit(boolean ai) {
        this.isAutoInit = ai;
    }

    public void setCombatSense(int x) {
        this.skillCombatSense = x;
    }

    public void setCurInitiative(int x) {
        this.curInitiative = x;
    }

    public void setActions(int x, int y) {
        this.curActions = x;
        this.prevActions = y;
    }

    public void setInit(int i) {
        this.curInitiative = i;
    }

    public void damageChar(int dam) {
        if (dam >= this.fleshWound) {
            if (dam < this.deepWound && dam >= this.fleshWound) {
                if (this.curFleshWound == 0) {
                    if (this.curDeepWound == 0) {
                        this.isDead = true;
                    } else {
                        --this.curDeepWound;
                        this.woundModifier -= 2;
                    }
                } else {
                    --this.curFleshWound;
                    --this.woundModifier;
                }
            } else if (dam < this.instantDeath && dam >= this.deepWound) {
                if (this.curDeepWound == 0) {
                    this.isDead = true;
                } else {
                    --this.curDeepWound;
                    this.woundModifier -= 2;
                }
            } else if (dam >= this.instantDeath) {
                this.curInitiative = -2222;
                this.isDead = true;
            }
        }
        if (this.woundModifier + this.systemShock <= 0) {
            this.isShock = true;
            this.roundsTillDead = (this.systemShock * 2 + this.woundModifier) * 6;
            if (this.roundsTillDead <= 0) {
                this.isDead = true;
            }
        }
    }

    public void healCharFW() {
        if (this.isDead) {
            System.out.println("Can't heal a dead char. RES HIM!");
        } else if (this.curFleshWound == this.fleshWound) {
            System.out.println("No more fleshwounds to heal.");
        } else {
            ++this.curFleshWound;
            ++this.woundModifier;
        }
        if (this.woundModifier + this.systemShock > 0) {
            this.isShock = false;
        }
    }

    public void healCharDW() {
        if (this.isDead) {
            System.out.println("Can't heal a dead char. RES HIM!");
        } else if (this.curDeepWound == this.deepWound) {
            System.out.println("No more deepwounds to heal.");
        } else {
            ++this.curDeepWound;
            this.woundModifier += 2;
        }
        if (this.woundModifier + this.systemShock > 0) {
            this.isShock = false;
        }
    }

    public void healCharID() {
        this.curDeepWound = this.deepWound;
        this.curFleshWound = this.fleshWound;
        this.isDead = false;
        this.isShock = false;
    }

    public void rollInit(int bonus) {
        int roll = 0;
        roll = this.skillCombatSense == 0 ? this.dice.unskilledroll() : this.dice.roll(this.skillCombatSense);
        this.curInitiative = roll == 1 ? -1111 : (roll + bonus + this.priAttrib[7] > 0 ? roll + bonus + this.priAttrib[7] : 1);
    }

    public void processShock() {
        if (this.isShock) {
            --this.roundsTillDead;
            if (this.roundsTillDead <= 0) {
                this.isDead = true;
            }
        }
    }
}

